ScriptName RF:FuelTankHandler Extends ActiveMagicEffect

RF:FuelHandlerQuest Property FuelManager Auto Mandatory Const

Potion Property TankHigh Mandatory Const Auto
{ Indicated by duration 7 }
Potion Property TankMed Mandatory Const Auto
{ Indicated by duration 8 }
Potion Property TankLow Mandatory Const Auto
{ Indicated by duration 9 }

MiscObject Property EmptyTank Mandatory Const Auto

Message Property FailMessage Mandatory Const Auto
{ This will show if we are not in our ship }
Message Property WrongLocationMessage Mandatory Const Auto
{ This may or may not display when we did not have the fuel in our cargo hold}
Message Property SuccessMessage Mandatory Const Auto
{ This will show when refueling completes.}
Message Property StartMessage Mandatory Const Auto
{ Show if we need fuel and are good to go }
Message Property WasteMessage Mandatory Const Auto
{ Show if we didn't need the item}

bool IsInHold = false
bool IsInShip = false
bool WasteHe3 = false
Float FillAmount = 1.0

Potion TheTank

;I have to queue whether or not we can refuel here.
Event OnEffectStart(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, float afMagnitude, float afDuration)
    If FuelManager.ModRunning()
        If afDuration == 7.0
            TheTank = TankHigh
        ElseIf afDuration  == 8.0
            TheTank = TankMed
        ElseIf afDuration == 9.0
            TheTank = TankLow
        EndIF
        Utility.Wait(0.75)
        IsInShip = FuelManager.CheckInShip() ; We also have to be in our ship to refuel.
        FillAmount = afMagnitude ; * Duration - Since this doesn't directly fucking do anything we have to script the fill. Thanks Todd!!!
        Float fuelNeeded = FuelManager.CheckFuelAmount(true)
        int FuelWeHave = FuelManager.CheckFuelAmount(false) as int
        FuelManager.DBG("FuelTankHandler started for tank type " + TheTank + " with fuel " + FuelWeHave + " and refuel amount " + FillAmount + "vs required" + fuelNeeded)
        WasteHe3 = ( ( FillAmount / 3 ) > fuelNeeded ) as bool
        If WasteHe3 || !IsInShip ;; || !IsInHold ; You can't actually use items from the hold. D'oh!
            Dispel()
        Else
            StartMessage.Show(FuelWeHave)
        EndIF
    EndIf
EndEvent

;Worst case - I will simply script the effect. But it should work just like the ship parts...
Event OnEffectFinish(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, float afMagnitude, float afDuration)
    If FuelManager.ModRunning() ; Just let the player eat it otherwise
        int FuelInShip = FuelManager.CheckFuelAmount(false) as int
        ;First we need to be on the ship
        IF !IsInShip ; This indicates a dispel
            FailMessage.Show()
            FuelManager.HandleReturn(TheTank)
            FuelManager.DBG("FuelTankHandler failed step 1: " + FuelInShip )
        ElseIf WasteHe3 ; This indicates a dispel with not enough remaining
            WasteMessage.Show()
            FuelManager.HandleReturn(TheTank) ; , true) - No reason to stuff it in the hold unfortunately
            FuelManager.DBG("FuelTankHandler failed step 2: " + FuelInShip )
        Else ; This indicates we're all good. Fire relevant logic
            FuelManager.Realfuel(false, afMagnitude)
            FuelInShip = FuelManager.CheckFuelAmount(false) as int ; Update here obviously
            SuccessMessage.Show(FuelInShip) 
            FuelManager.DBG("FuelTankHandler complete: " + FuelInShip )
            Utility.Wait(0.3)
            akCaster.AddItem(EmptyTank, 1)
        EndIF
    EndIf
EndEvent